#include <math.h>

#include "sl_shared.h"

/* formula for ccalculating frequency
   freq = 440 * 2^(n/12)
*/

int main (int argc, char **argv) {

   char notes[12][3] = {"A", "A#", "B", "C", "C#", "D", 
                        "D#", "E", "F", "F#", "G", "G#"};
   char *c;
   int i = 0, n, lower, upper;
   double freq, *resarr;

   if (argc != 3) {
     fprintf (stderr, "wrong number of arguments\n"
                      "Put in two numbers specifying the range of N "
                      "where N = 0 is A bove Middle C\n");
     return 1;
   }

   lower = strtol (argv[1], &c, 0);
   invalid_num(*c);
   upper = strtol (argv[2], &c, 0);
   invalid_num(*c);

   resarr = (double *) malloc ((upper - lower) * sizeof (double));
   
   for (n = lower; n <= upper; n++) {
      int tmp = (n + 1200)%12;
      freq = 440 * pow (2.0, (n/12.0));
      printf ("Note: %2s  N: %3d Frequency: %f\n", notes[tmp], n, freq);
      resarr[i] = freq;
      i++;
   }

   for (i = 0; i <= (upper - lower); i++) {
      printf ("%d, ", (int) floor (resarr[i] + 0.5));
   }
   printf ("\n");
   free (resarr);

   return 0;
}
