/******************************************************************************
 * sl_client -- a simple (pretty much example code) client for the sl_server  *
 *                                                                            *
 * Author: Steven Hanley                                                      *
 * Date: 15/04/99                                                             *
 * Last Modified: See ChangeLog                                               *
 ******************************************************************************/

#include "sl_shared.h"

int main (int argc, char **argv) {
   int sock, usec_delay, done_delay = 0;
   char str[SLEN];
   FILE *fh;

   if ((argc <= 1) || (argc > 3)) {
      fprintf (stderr, "incorrect number of arguments use:\n"
                       "%s host number\" where number is the time span\n"
                       "in seconds between each update any multiple of 0.25 is\n"
                       "also legal such as 0.5 or 2.75 for example. %s host 1\n"
                       "will update the output every second, if no second\n"
                       "argument is specified 0.25 is assumed (every 1/4 second)\n",
                       argv[0], argv[0]);
      return 1;
   } else if (argc == 2) {
      usec_delay = 250000;
   } else {
      usec_delay = get_usec_delay(argv[2]);
   }

   sock = connect_sl_server (argv[1]);
   fh = fdopen (sock, "r");

   /* we rely on the fact we get a line from the server every 0.25 seconds for the 
      timing, this may not be a good assumption on a congested link or slow network
      however for now and seeing this is only example code it will do */
   while (fgets (str, SLEN, fh)) {
      done_delay += 250000;

      if (done_delay == usec_delay) {
         char *cts;
         int levels[2], i;

         cts = getHHMMSS();
         done_delay = 0;

         get_levels_from_string (str, levels);

         for (i = 0; i < levels[0]; i++) {
            str[i] = '#';
         }
         str[i++] = '\0';
         printf ("%s %s silence %2d signal %2d %s\n", argv[1], cts, levels[1], levels[0], str);
         fflush(stdout);
      } 
   }
   
   return 0;
}
