/******************************************************************************
 * sl_sclient -- a simple sl_server client that outputs beeps of different    *
 *               frequencies depending on singal strength to the pc speaker   *
 *                                                                            *
 * Author: Steven Hanley                                                      *
 * Date: 16/04/99                                                             *
 * Last Modified: See ChangeLog                                               *
 ******************************************************************************/

#include "sl_shared.h"

int main (int argc, char **argv) {
   int sock, usec_delay, done_delay = 0;
   char str[SLEN];
   FILE *fh;
   /* musical scale, middle c on upwards for 20 whole notes, 
      ie C D E F G A B C D etc */
   int frequency[20] = {262,  294,  330,  349,  392,  440,  494,  523,  587,  659,
                        698,  784,  880,  988, 1047, 1175, 1319, 1397, 1568, 1760};

   if ((argc <= 1) || (argc > 3)) {
      fprintf (stderr, "incorrect number of arguments use:\n"
                       "%s host number\" where number is the time span\n"
                       "in seconds between each update any multiple of 0.25 is\n"
                       "also legal such as 0.5 or 2.75 for example. %s host 1\n"
                       "will update the output every second, if no second\n"
                       "argument is specified 0.25 is assumed (every 1/4 second)\n",
                       argv[0], argv[0]);
      return 1;
   } else if (argc == 2) {
      usec_delay = 250000;
   } else {
      usec_delay = get_usec_delay(argv[2]);
   }

   sock = connect_sl_server (argv[1]);
   fh = fdopen (sock, "r");

   /* we rely on the fact we get a line from the server every 0.25 seconds for the 
      timing, this may not be a good assumption on a congested link or slow network
      however for now and seeing this is only example code it will do */
   while (fgets (str, SLEN, fh)) {
      done_delay += 250000;

      if (done_delay == usec_delay) {
         int levels[2], slevel;

         done_delay = 0;

         get_levels_from_string (str, levels);
         slevel = levels[0];
         /* if the level is 0 it means no new message, beep otherwise */
         if (slevel >= 1) {
            slevel -= 1;
            if (slevel > 19) slevel = 19; /* array bounds must be adhered to */
            beep (frequency[slevel], 250);
         }
      } 
   }
   
   return 0;
}
