#include "sl_shared.h"

/* used just after a call to strtol orr similar to ensure that the call succeeded */
void invalid_num (const char ch) {
   if ((ch != '\0') && (ch != '\n')) {
      fprintf(stderr, "'%c' invalid characters in number\n", ch);
      exit (0);
   }
}

/* return the ip address */
char *lookup_host (const char *hostid) {

   static char str[SLEN];
   char **pptr;
   struct hostent *nstruct;
   struct in_addr iaddr;

   if (! inet_aton(hostid, NULL)) {
      if ((nstruct = gethostbyname (hostid)) == NULL) {
         fprintf (stderr, "addr: %s DNS error, likely Host name lookup "
                          "failure\n", hostid);
         return NULL;
      }
      pptr = nstruct->h_addr_list;
      iaddr.s_addr = ((struct in_addr *)(*pptr))->s_addr;
      return inet_ntoa(iaddr);
   }
   strncpy (str, hostid, SLEN);

   return str;
}


/* connects to the server with this ipaddress and returns a file descriptor of 
   the socket */
int connect_sl_server (const char *hostid) {
   struct sockaddr_in serv;
   int sock;
   char *host;

   if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
      fprintf (stderr, "error in socket call: %s\n", strerror(errno));
      exit (1);
   }

   memset (&serv, 0, sizeof(serv));
   serv.sin_family = AF_INET;
   serv.sin_port = htons (PORT);

   host = lookup_host (hostid);
   if (inet_pton(AF_INET, host, &serv.sin_addr) < 0) {
      fprintf (stderr, "inet_pton error for %s: %s\n", hostid, strerror(errno));
      exit (1);
   }

   if (connect (sock, (SA *) &serv, sizeof(serv)) < 0) {
      fprintf (stderr, "error in connect call: %s\n", strerror(errno));
      exit (1);
   }

   return sock;
}

/* converts the number string to an integer of the number of microseconds equal
   the the number which is in seconds */
int get_usec_delay (const char *number) {
   char *tmp;
   int rval, sig_val = 0;

   if (strchr(number, '.')) {
      /* this stupid load of special case code is here as I couldn't get strtod
         to return anything other than 0.0000 */
      if (! strstr(number, "0.")) {
         char *tmpstr;
         tmpstr = strdup (number);
         tmpstr = strtok (tmpstr, ".");
         sig_val = (int) strtol (tmpstr, &tmp, 0);
         invalid_num(*tmp);
         sig_val = sig_val * 1000000;
         free(tmpstr);
      }

      if (strstr(number, ".25")) {
         rval = 250000 + sig_val;
      } else if (strstr(number, ".5")) {
         rval = 500000 + sig_val;
      } else if (strstr(number, ".75")) {
         rval = 750000 + sig_val;
      } else {
         fprintf (stderr, "the number entered was invalid it must be a multiple of "
                          "0.25, eg. 0.5 or 2.75 etc\n");
         exit (1);
      }
   } else {
      int argval_int;
      argval_int = (int) strtol (number, &tmp, 0);
      invalid_num(*tmp);
      rval = argval_int * 1000000;
   }

   return rval;
}


/* I found the fprintf statement used here in the beep.c from the
   console_beep v0.1 by Josef Pavlik in 
   metalab.unc.edu/pub/Linux/apps/sound/console_beep-0.1.tar.gz
   there doesnt seem to be a licence but credit is due him 
   I have put this in here instead of sl_sclient.c only as other people
   may want to be able to beep, this provides a very nice interface */

/* I was unable to get the ioctl to work
   ioctl(fd, KDMKTONE, (ticks<<16 | (1193180/hertz)));
   as described in the linux programmers guide on LDP in the section about
   the pc speaker

   if anyone knows how please contribute :) (opening /dev/console and doing 
   the ioctl on that fd I was getting an EBADF
*/
void beep(int freq, int length) {
   FILE *dest;

#ifdef USE_PROC
#define PCSPEAKER_INTERFACE "/proc/pcspeaker"
#else
#define PCSPEAKER_INTERFACE "/dev/tty1"
#endif /* USE_PROC */

  dest = fopen (PCSPEAKER_INTERFACE, "w");
  if (! dest) {
     fprintf (stderr, "couldn't open %s for writing, error: %s\n", 
              PCSPEAKER_INTERFACE, strerror(errno));
     exit (1);
  }

#ifdef USE_PROC
  fprintf (dest, "%d %d\n", freq, length);
#else
  fprintf (dest,"\33[10;%d]\33[11;%d]\a\33[10]\33[11]", freq, length);
#endif /* USE_PROC */
  fflush (dest);
  fclose (dest);
}

void get_levels_from_string (char *str, int *levels) {
   char *tmp, *c;

   c = strtok (str, " ");
   levels[0] = (int) strtol (c, &tmp, 0);
   invalid_num(*tmp);

   c = strtok (NULL, " ");
   levels[1] = (int) strtol (c, &tmp, 0);
   invalid_num(*tmp);
}

/* returns a pointer to a static HH:MM:SS */
char *getHHMMSS () {
   static char cts[9];
   time_t currtime;

   time (&currtime);
   snprintf (cts, 9, "%.9s\0", ctime(&currtime) + 11);
   return cts;
}
