/* thanks must go to Martijn for the basic parts of this source to which 
   I just added some features as I liked the idea of dockable, colored thing
   with a little string saying which machine this is, oh also I stopped the 
   damn thing flickering by using a drawable that isnt displayed (the pixmap) 
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "sl_shared.h"

#define HEIGHT 64
#define WIDTH 64
#define LBUFF_LEN 64
#define SCALE_MULTIPLIER 3 /* for the graph lines, how many times longer the drawn lines
                              are to the real signal level, 1 would be exact signal level
                              to pixel */

static float lbuff[LBUFF_LEN];

void addNumToTailLbuff (float num) {
   memcpy (lbuff, lbuff+1, (LBUFF_LEN-1) * sizeof(lbuff[0]));
   lbuff [LBUFF_LEN-1] = num;
}

/* change this si ibnstead of drawing line at a time to the display
   draw the whole block to a pixmap in the loop and then draw the pixmap
   to the display, this will decrease flicker and make things dipaly nicer */
void DrawWindow (Display *xdisp, Window win, Pixmap pxm, GC fg, GC bg, GC xf, char *host) {
   int i;

   XFillRectangle (xdisp, pxm, bg, 0, 0, WIDTH, HEIGHT);
   XDrawString (xdisp, pxm, fg, 10, 10, host, strlen (host));
   for (i = 0; i < LBUFF_LEN; i++) {
      XDrawLine (xdisp, pxm, fg, i, 64-lbuff[i], i, 64);
   }
   /* draw the number ticks */
   for (i = 64; i > 0; i-=6) {
      XDrawLine (xdisp, pxm, xf, 59, i, 64, i);
   }
   XCopyArea (xdisp, pxm, win, fg, 0, 0, WIDTH, HEIGHT, 0, 0);
   XFlush (xdisp);
}

int main (int argc, char **argv) {
   XEvent ev;
   Display *xdisp;
   Window win;
   GC fg, bg;
   GC xored;
   XWMHints mywmhints;

   Pixmap pxm;
   Colormap colourmap;
   XColor col_req, col_given;
   char *bgname = "black", *fgname = "LightSeaGreen";

   XFontStruct *fontstruct;
   char *fontname = "-adobe-times-bold-r-normal--12-120-75-75-p-*-iso8859-1";

   int scr, sock;
   float oldnum = 20.0;
   char *remotehost;
   FILE *fh;

   if (argc != 2) {
      fprintf (stderr, "wrong number of arguments specify \"programname hostname\"\n");
      return 1;
   }

   remotehost = argv[1];

   xdisp = XOpenDisplay (NULL);
   scr = DefaultScreen (xdisp);

   win = XCreateSimpleWindow (xdisp, RootWindow (xdisp, scr), 0, 0, WIDTH, HEIGHT, 0, 
                              BlackPixel (xdisp, scr), WhitePixel (xdisp, scr));
   colourmap = DefaultColormap (xdisp, scr);

   /* create a pixmap drawable so it may be drawn to and then the window updated in one step */
   pxm = XCreatePixmap (xdisp, win, WIDTH, HEIGHT, DefaultDepth (xdisp ,scr));

   /* set foreground and background of the graph colours, should the 
      colour be a command line option? */
   bg = XCreateGC (xdisp, pxm, 0, NULL);
   XAllocNamedColor (xdisp, colourmap, bgname, &col_req, &col_given);
   XSetBackground (xdisp, bg, col_given.pixel);

   fg = XCreateGC (xdisp, pxm, 0, NULL);
   XAllocNamedColor (xdisp, colourmap, fgname, &col_req, &col_given);
   XSetForeground (xdisp, fg, col_given.pixel);

   /* make the ticks display in opposite colour */
   xored = XCreateGC (xdisp, pxm, 0, NULL);
   XSetFunction (xdisp, xored, GXxor);
   XSetForeground (xdisp, xored, col_given.pixel);

   /* load and set the required font */
   fontstruct = XLoadQueryFont (xdisp, fontname);
   XSetFont(xdisp, fg, fontstruct->fid);

   /* make the program dock */
   mywmhints.initial_state = WithdrawnState;
   mywmhints.flags = StateHint;
   XSetWMHints (xdisp, win, &mywmhints);
   
   XmbSetWMProperties (xdisp, win, "sl_xclient", "sl_xclient", NULL, 0, NULL, NULL, NULL);

   XSelectInput (xdisp, win, ExposureMask);

   XMapWindow (xdisp, win);
   sock = connect_sl_server (remotehost);
   fh = fdopen (sock, "r");
   while (1) {
      char str[SLEN];
      while (XPending(xdisp)) {
         XNextEvent (xdisp, &ev);
         if (ev.type == Expose) {
            DrawWindow (xdisp, win, pxm, fg, bg, xored, remotehost);
			}
  	   }
      if (fgets (str, SLEN, fh)) {
         int levels[2];
         float new_level;

         get_levels_from_string (str, levels);
         new_level = (oldnum*0.6) + ((levels[0] * SCALE_MULTIPLIER)*0.4);
         oldnum = new_level;
         //         fprintf (stderr, "%f ", new_level);
         addNumToTailLbuff (new_level);
         DrawWindow (xdisp, win, pxm, fg, bg, xored, remotehost);
		}

   }

   return 0;
}
